function [surv]=survivalcurve(X)
% takes a a ln per 100 mortality rate vector 
% and returns a survival curve of same size
    TT=length(X);
    XX=exp(X);
    surv=100*ones(TT,1);
    surv(1)=100*(1-XX(1));
    for t=2:TT
        surv(t)=surv(t-1)*(1-XX(t));
    end
end
